 ; Pit - rotate text into the next isoplane.
 ; Copyright 1994 by Rocket Software.
 ; Not for those who thought isometrics were a type of aerobics.
  (DEFUN C:PIT (/ txt rota oblq newrot newobl)
   (setq txt (entget (car (entsel "Text to pivot: "))))
   (setq 11pi6 (* pi (/ 11.0 6)))                       ; 11Pi/6 = 330
   (setq piovr6 (/ pi 6))                               ; Pi/6 = 30.
   (setq halfpi (/ pi 2))                               ; Pi/2 = 90
 ; See what it was and react accordingly.  If it wasn't text:
   (cond ((/= (cdr (assoc 0 txt)) "TEXT")
          (write-line "\nThat was not text"))
 ; The rotation or obliquing groups weren't present.  (Might later on
 ; modify so can add them.)
         ((or (null (setq rota (assoc 50 txt)))
              (null (setq oblq (assoc 51 txt))))
          (write-line "\nThat was not isometric text"))
 ; If there was a rotation and obliquing angle group matching a standard iso
 ; text style then cycle it through to the next plane.  (The order matches
 ; the order of testing in this file.)
 ; Rotation = Pi/6 = 30; Obliquing angle = Pi/6 = 30 (ISO30VERT)
         ((and (equal (cdr rota) piovr6 0.005)
               (equal (cdr oblq) piovr6 0.005))
          (setq txt (subst (cons 50 11pi6) rota txt))
          (entmod (subst (cons 51 11pi6) oblq txt)))
 ; Rotation = 11Pi/6 = 330; Obliquing angle =11Pi/6 = 330 (ISO330VERT)
         ((and (equal (cdr rota) 11pi6 0.005)
               (equal (cdr oblq) 11pi6 0.005))
          (setq txt (subst (cons 50 halfpi) rota txt))
          (entmod (subst (cons 51 piovr6) oblq txt)))
 ; Rotation = Pi/2 = 90; Obliquing angle = Pi/6 = 30 (ISO90LEFT)
         ((and (equal (cdr rota) halfpi 0.005)
               (equal (cdr oblq) piovr6 0.005))
          (setq txt (subst (cons 50 piovr6) rota txt))
          (entmod (subst (cons 51 11pi6) oblq txt)))
 ; Rotation = Pi/6 = 30; Obliquing angle = 11Pi/6 = 330 (ISO30HOR)
         ((and (equal (cdr rota) piovr6 0.005)
               (equal (cdr oblq) 11pi6 0.005))
          (setq txt (subst (cons 50 11pi6) rota txt))
          (entmod (subst (cons 51 piovr6) oblq txt)))
 ; Rotation = 11Pi/6 = 330; Obliquing angle = Pi/6 = 30 (ISO330HOR)
         ((and (equal (cdr rota) 11pi6 0.005)
               (equal (cdr oblq) piovr6 0.005))
          (setq txt (subst (cons 50 halfpi) rota txt))
          (entmod (subst (cons 51 11pi6) oblq txt)))
 ; Rotation = Pi/2 = 90; Obliquing angle = 11Pi/6 = 330 (ISO90RIGHT)
 ; or any other undefined (but with 50 and 51 lists) text.
         (T
          (setq txt (subst (cons 50 piovr6) rota txt))
          (entmod (subst (cons 51 piovr6) oblq txt))))
 (princ))